/*------------------------------------------------------------------------------*
 * File Name: Derivative.cpp	 													*
 * Creation: SDB 5/13/2003														*
 * Purpose: OriginC Source CPP file for auto update smoothing routines	.		*
 * Copyright (c) OriginLab Corp.	2003-2007									*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 *------------------------------------------------------------------------------*/



//////////////////////////////////////////////////////////////////////////////////
// Included header files
//////////////////////////////////////////////////////////////////////////////////

// System includes
#include <Origin.h>
#include <Operation.h>    // Operation class
#include <Tree.h>         // Tree class
#include <analysis_utils.h>
#include <GetNBox.h>
#include <ColumnFormulaEx.h>

// Define Constants

#define DERIV_DLG_TITLE				"Derivative"
#define DERIV_PLOT_OPTION			"Plot"
#define DERIV_CURVE_COLOR			"Derivative Curve Color"
#define DERIV_BASE_PLOT_NAME		"DerivPlot"
#define DERIV_PAGE_LABEL_PREFIX		"Derivative of"
#define DERIV_PLOT_TEMPLATE			"Origin.otp"
#define DERIV_RESULT_NODE			"Result"
#define DERIV_BASE_WKS_NAME			"Derivative"
#define DERIV_RESULT_COL_NAMES		"Name|Value"
#define DERIV_DELIM					'|'



////////////////////////////////////////////////////////////////////////////
// C - functions
////////////////////////////////////////////////////////////////////////////

static bool Derivative_dlg_event(TreeNode& ExpDecay, int nRow, int nType, Dialog& dlgGetNBox)
{
	return TRUE;
}

//////////////////////////////////////////////////////////////////////////////////
// Class Derivative
//////////////////////////////////////////////////////////////////////////////////
// Possible values of nOption in Init() 

class	Derivative : public	ColumnFormulaEx
{
	BOOL	ConstructGUINode(TreeNode &tr, int nOption)
	{
		GETN_CURVE_OPERATION(myTree)
		GETN_LIST(PlotOption, DERIV_PLOT_OPTION, CFE_PLOT_OPTION_NEW_GRAPH, CFE_PLOT_OPTIONS);
		GETN_LIST(nDiffOrder, "Order", 0, "First|Second|Third|Forth")
		//GETN_NUM(dSmoothness, "Smoothness", 0)
		GETN_COLOR(CurveColor, DERIV_CURVE_COLOR, 1);
		ColumnFormulaEx::ConstructAddCommon(myTree);
		tr = myTree;
		return TRUE;
	}
	

	BOOL	GUItoOperationSpec(TreeNode& trOperation, TreeNode &trGUI, int nOption)
	{
		trOperation.Settings.nDiffOrder.nVal = trGUI.nDiffOrder.nVal;
		//trOperation.Settings.dSmoothness.dVal = trGUI.dSmoothness.dVal;
		//trOperation.Output.Name.strVal= "Deriv";
		trOperation.Output.DefaultName.strVal = DERIV_BASE_WKS_NAME;
		trOperation.Output.DefaultColName.strVal = DERIV_BASE_WKS_NAME;
		return TRUE;
	}
	
	BOOL	OperationtoGUISpec(TreeNode& trOperation, TreeNode &trGUI, bool bInit)
	{
		trGUI.nDiffOrder.nVal = trOperation.Settings.nDiffOrder.nVal;
		//trGUI.dSmoothness.nVal = trOperation.Settings.dSmoothness.dVal;
		return TRUE;
	}

	BOOL	DoFormula(Column &colOutput, Column &colOutputX, TreeNode &tr)
	{
		curvebase	&crvInput = GetCurveInput();
		vectorbase	&vResult = colOutput.GetDataObject();
		vResult.SetSize(crvInput.GetSize());

		int r1 = tr.Input.Range1.R1.nVal;
		int r2 = tr.Input.Range1.R2.nVal;
		int	nErr;		

		int nMissingValues, nOffset;
		DWORD dwCntrl = CURVECOPY_SCAN_OVER_MISSING_FROM_LEFT | CURVECOPY_SCAN_OVER_MISSING_FROM_RIGHT | CURVECOPY_REPLACE_MISSING_INSIDE;
		Curve crvTemp(crvInput, nMissingValues, nOffset, dwCntrl, r1, r2);
		
		int			nOrder = tr.Settings.nDiffOrder.nVal;
		//double		dSmoothness = tr.Settings.dSmoothness.dVal;
		for(int nIter = 1; nIter <= nOrder + 1; nIter++)
		{
			nErr = Curve_derivative(&crvInput, &crvTemp, 1);
		}
		//vResult.SetSubVector(crvTemp, nOffset);
		SetResultsData(vResult, colOutputX, crvTemp, nOffset);

		return TRUE;
	}

	void UpdateReportingHeaderContents(TreeNode &trOperation, bool bInit = false)
	{
		ColumnFormulaEx::UpdateReportingHeaderContents(trOperation, bInit);
		
		if (bInit)		
		{
			if (!trOperation.Reporting.Contents.Header.Table)
			{
				ASSERT(FALSE);	// should have been initialized in the baseclass
				return;
			}
			
			TreeNode		trTable = trOperation.Reporting.Contents.Header.Table;
			
			// Init labels:
		}
		else		// update after execution
		{
			if (!trOperation.Reporting.Contents.Header.Table)
			{
				ASSERT(FALSE);	// must have been intialized before
				return;
			}
			
			//if (!trOperation.Output.Result)
			//{
			//	ASSERT(FALSE);	// must have been intialized before (in DoFormula())
			//	return;
			//}
			
			TreeNode		trResult = trOperation.Output.Result;
			TreeNode		trTable = trOperation.Reporting.Contents.Header.Table;
			
		}
	}
	
	BOOL	GetGraphInfo(string &strTemplate, string &strBasePageName, string &strPageLabelPrefix, int &nPlotType)
	{
		strTemplate = DERIV_PLOT_TEMPLATE;
		strBasePageName = DERIV_BASE_PLOT_NAME;					
		strPageLabelPrefix = DERIV_PAGE_LABEL_PREFIX;
		nPlotType = IDM_PLOT_LINE;
		return TRUE;
	}


	//string GetResultBaseName()
	//{
	//	return DERIV_BASE_WKS_NAME;
	//}

	PEVENT_FUNC GetEventFunction()
	{
		return Derivative_dlg_event;
	}
};